<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateStudentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'school_id' => 'sometimes|required|exists:schools,id',
            'name' => 'sometimes|required|string|max:255',
            'student_id' => 'sometimes|required|string|max:255',
            'email' => 'nullable|email|max:255',
            'biometric_template' => 'nullable|string',
        ];
    }

    public function messages(): array
    {
        return [
            'school_id.required' => 'A school must be selected.',
            'school_id.exists' => 'The selected school does not exist.',
            'name.required' => 'Student name is required.',
            'student_id.required' => 'Student ID is required.',
            'email.email' => 'The email address must be valid.',
        ];
    }
}
