<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class School extends Model
{
    protected $fillable = [
        'name',
        'contact_email',
        'contact_phone',
        'status',
        'subscription_expires_on',
    ];

    protected $casts = [
        'subscription_expires_on' => 'date',
    ];

    public function students(): HasMany
    {
        return $this->hasMany(Student::class);
    }
}
