<?php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\School;
use App\Models\Student;

// Create a test school
$school = School::create([
    'name' => 'Test School',
    'contact_email' => 'test@school.com',
    'contact_phone' => '555-1234',
    'status' => 'active',
]);

echo "School created with ID: " . $school->id . "\n";

// Create a test student
$student = Student::create([
    'school_id' => $school->id,
    'name' => 'John Doe',
    'student_id' => 'STU001',
    'email' => 'john@example.com',
]);

echo "Student created with ID: " . $student->id . "\n";
echo "JSON:\n";
echo json_encode(['school_id' => $school->id, 'student_id' => $student->id], JSON_PRETTY_PRINT);
