<?php
require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

$user = \App\Models\User::firstOrCreate(
    ['email' => 'test@example.com'],
    ['name' => 'Test User', 'password' => bcrypt('password')]
);

$token = $user->createToken('api-token')->plainTextToken;

echo "========================================\n";
echo "User created successfully!\n";
echo "========================================\n";
echo "User ID: {$user->id}\n";
echo "Email: {$user->email}\n";
echo "Name: {$user->name}\n";
echo "========================================\n";
echo "API Token:\n";
echo $token . "\n";
echo "========================================\n";
echo "\nUse this token in your API requests:\n";
echo "Authorization: Bearer {$token}\n";
echo "========================================\n";
