<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ $school->name }}
            </h2>
            <div class="flex gap-2">
                <a href="{{ route('schools.edit', $school) }}"
                    class="bg-indigo-500 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded">
                    {{ __('Edit') }}
                </a>
                <a href="{{ route('schools.index') }}"
                    class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
                    {{ __('Back') }}
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg">
                <div class="px-4 py-5 sm:p-6">
                    <dl class="grid grid-cols-1 gap-x-4 gap-y-8 sm:grid-cols-2">
                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">{{ __('School Name') }}</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $school->name }}</dd>
                        </div>

                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">{{ __('Status') }}</dt>
                            <dd class="mt-1 text-sm">
                                <span
                                    class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                                    @if ($school->status === 'active') bg-green-100 text-green-800
                                    @elseif ($school->status === 'inactive') bg-yellow-100 text-yellow-800
                                    @else bg-red-100 text-red-800 @endif">
                                    {{ ucfirst($school->status) }}
                                </span>
                            </dd>
                        </div>

                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">{{ __('Contact Email') }}</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $school->contact_email ?? '-' }}
                            </dd>
                        </div>

                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">{{ __('Contact Phone') }}</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $school->contact_phone ?? '-' }}
                            </dd>
                        </div>

                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">{{ __('Subscription Expires') }}</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $school->subscription_expires_on?->format('M d, Y') ?? '-' }}
                            </dd>
                        </div>

                        <div class="sm:col-span-1">
                            <dt class="text-sm font-medium text-gray-500">{{ __('Created') }}</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $school->created_at->format('M d, Y H:i') }}
                            </dd>
                        </div>

                        <div class="sm:col-span-2">
                            <dt class="text-sm font-medium text-gray-500">{{ __('Last Updated') }}</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                {{ $school->updated_at->format('M d, Y H:i') }}
                            </dd>
                        </div>
                    </dl>
                </div>

                <div class="px-4 py-4 sm:px-6 border-t border-gray-200">
                    <form action="{{ route('schools.destroy', $school) }}" method="POST"
                        onsubmit="return confirm('Are you sure you want to delete this school?');">
                        @csrf
                        @method('DELETE')
                        <button type="submit"
                            class="bg-red-500 hover:bg-red-700 text-white font-bold py-2 px-4 rounded">
                            {{ __('Delete School') }}
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
