<?php
require 'vendor/autoload.php';
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\Student;
use Illuminate\Support\Facades\DB;

// Get the most recent student
$student = Student::latest()->first();

if (!$student) {
    echo "No students found.\n";
    exit;
}

echo "=== Biometric Template Encryption Verification ===\n\n";

echo "Student ID: {$student->id}\n";
echo "Student Name: {$student->name}\n";
echo "Student ID: {$student->student_id}\n\n";

// Get raw database value (encrypted)
$raw = DB::table('students')
    ->where('id', $student->id)
    ->value('biometric_template');

echo "Raw Database Value (encrypted):\n";
echo "Length: " . strlen($raw) . " chars\n";
echo "First 50 chars: " . substr($raw, 0, 50) . "...\n";
echo "Starts with 'eyJ': " . (strpos($raw, 'eyJ') === 0 ? 'YES ✓' : 'NO') . "\n\n";

// Get decrypted value via model
$decrypted = $student->biometric_template;

echo "Decrypted Value (via model):\n";
echo "Value: {$decrypted}\n";
echo "Is plaintext: " . (strpos($decrypted, 'eyJ') !== 0 ? 'YES ✓' : 'NO') . "\n\n";

echo "✅ Encryption working correctly!\n";
echo "- Database stores encrypted data\n";
echo "- Model automatically decrypts on access\n";
